#  Phase_Main
# CtF[Y
# Author:: fukuyama
# Date:: 2011/04/13
# Copyright:: Copyright (c) 2005 rgss-lib(sourceforge.jp)

module DQ
  module Battle
    class Phase_Main
      include Battle_Phase_Base_Module

      attr_reader :active_battler

      attr_reader :target

      attr_reader :skill

      attr_reader :item

      # 萔ݒ
      @@action_log_critical_se = nil
      @@action_log_critical_se = ACTION_LOG_CRITICAL_SE if Module.constants.include?('ACTION_LOG_CRITICAL_SE')

      @@action_log_attack_hit_se = nil
      @@action_log_attack_hit_se = ACTION_LOG_ATTACK_HIT_SE if Module.constants.include?('ACTION_LOG_ATTACK_HIT_SE')

      @@action_log_attack_miss_se = nil
      @@action_log_attack_miss_se = ACTION_LOG_ATTACK_MISS_SE if Module.constants.include?('ACTION_LOG_ATTACK_MISS_SE')

      @@action_log_shake_window_se = nil
      @@action_log_shake_window_se = ACTION_LOG_SHAKE_WINDOW_SE if Module.constants.include?('ACTION_LOG_SHAKE_WINDOW_SE')

      @@action_log_default_attack = ACTION_LOG_DEFAULT_ATTACK

      @@action_log_default_guard = ACTION_LOG_DEFAULT_GUARD

      @@action_log_default_escape = ACTION_LOG_DEFAULT_ESCAPE

      @@action_log_default_magic_skill = ACTION_LOG_DEFAULT_MAGIC_SKILL

      @@action_log_default_attack_skill = ACTION_LOG_DEFAULT_ATTACK_SKILL

      @@action_log_default_item_use_msg = ACTION_LOG_DEFAULT_ITEM_USE_MSG

      @@action_log_default_item_hit_msg = ACTION_LOG_DEFAULT_ITEM_HIT_MSG

      @@action_log_default_item_miss_msg = ACTION_LOG_DEFAULT_ITEM_MISS_MSG

      @@action_log_default_actor_critical = ACTION_LOG_DEFAULT_ACTOR_CRITICAL

      @@action_log_default_enemy_critical = ACTION_LOG_DEFAULT_ENEMY_CRITICAL

      @@action_log_default_damage_sp_actor = ACTION_LOG_DEFAULT_DAMAGE_SP_ACTOR

      @@action_log_default_damage_sp_enemy = ACTION_LOG_DEFAULT_DAMAGE_SP_ENEMY

      @@action_log_default_recover_sp_actor = ACTION_LOG_DEFAULT_RECOVER_SP_ACTOR

      @@action_log_default_recover_sp_enemy = ACTION_LOG_DEFAULT_RECOVER_SP_ENEMY

      # 퓬sRCxghc
      unless Module.constants.include?('BATTLE_ACTION_COMMON_EVENT_ID')
        # `ĖꍇRCxg
        common_event = Data_Loader.data_common_events.find {|e| (not e.nil?) and (e.name == '퓬sICxg') }
        if not common_event.nil?
          # RCxg炻̂hc̗p
          BATTLE_ACTION_COMMON_EVENT_ID = common_event.id
        end
      end

      def self.start
        # CtF[YJn
        $scene.phase = Phase_Main.new
      end

      def initialize
        @troop_id = $game_temp.battle_troop_id
        # ^[JEg
        $game_temp.battle_turn += 1
        # ogCxg̑Sy[W
        for index in 0...$data_troops[@troop_id].pages.size
          # Cxgy[W擾
          page = $data_troops[@troop_id].pages[index]
          # ̃y[W̃Xp [^[] ̏ꍇ
          if page.span == 1
            # sς݃tONA
            $game_temp.battle_event_flags[index] = false
          end
        end
        # AN^[IԂɐݒ
        @actor_index = -1
        @active_battler = nil
        # CtF[YtOZbg
        $game_temp.battle_main_phase = true
        # Gl~[ANV쐬
        $game_troop.enemies.each {|enemy| enemy.make_action}
        # s쐬
        make_action_orders
        # Xebv 1 Ɉڍs
        @phase4_step = 1

        # bZ[W\Ԋu퓬pɂ
        $scene.message_window.auto_message_interval = $game_system.user_default_battle_auto_message_interval
        # Xe[^XEBhE
        $scene.status_window.state_off
        # bZ[WEBhEȂ悤ɂ
        $scene.message_window.fade_out_off = true
      end

      def update
        case @phase4_step
        when 1
          update_phase4_step1
        when 2
          update_phase4_step2
        when 3
          update_phase4_step3
        when 4
          update_phase4_step4
        when 5
          update_phase4_step5
        when 6
          update_phase4_step6
        end
      end

      #--------------------------------------------------------------------------
      # ^[Qbgog[̃Xe[gۑ
      #--------------------------------------------------------------------------
      def backup_target_battlers_states
        @backup_target_battlers_states = {}
        $game_troop.enemies.each {|enemy| @backup_target_battlers_states[enemy] = enemy.states.clone}
        $game_party.actors.each {|actor| @backup_target_battlers_states[actor] = actor.states.clone}
      end

      #--------------------------------------------------------------------------
      # obNAbvꂽ^[Qbgog[̃Xe[g擾
      #--------------------------------------------------------------------------
      def get_backup_target_battlers_states(battler)
        return @backup_target_battlers_states[battler]
      end

      #--------------------------------------------------------------------------
      # ۑĂXe[ggĎw肳ꂽog[
      # VXe[gtꂽmF
      #--------------------------------------------------------------------------
      def target_battlers_new_states(battler)
        old_states = @backup_target_battlers_states[battler]
        return [] if old_states.nil?
        return battler.states - old_states
      end

      #--------------------------------------------------------------------------
      # ۑĂXe[ggĎw肳ꂽog[
      # Xe[g폜ꂽmF
      #--------------------------------------------------------------------------
      def target_battlers_delete_states(battler)
        old_states = @backup_target_battlers_states[battler]
        return [] if old_states.nil?
        return old_states - battler.states
      end

      #--------------------------------------------------------------------------
      #  s쐬
      #--------------------------------------------------------------------------
      def make_action_orders
        # z @action_battlers 
        @action_battlers = []
        # Gl~[z @action_battlers ɒǉ
        for enemy in $game_troop.enemies
          @action_battlers.push(enemy)
        end
        # AN^[z @action_battlers ɒǉ
        for actor in $game_party.actors
          @action_battlers.push(actor)
        end
        # S̃ANVXs[h
        for battler in @action_battlers
          battler.make_action_speed
        end
        # ANVXs[h̑傫ɕёւ
        @action_battlers.sort! {|a,b|
          b.current_action.speed - a.current_action.speed }
      end

      #--------------------------------------------------------------------------
      #  {ANV ʍ쐬
      #--------------------------------------------------------------------------
      def make_basic_action_result
        # Ȕꍇ
        if @active_battler.current_action.basic == 0
          # Aj[V ID ݒ
          @animation1_id = @active_battler.animation1_id
          @animation2_id = @active_battler.animation2_id
          # sog[Gl~[̏ꍇ
          if @active_battler.is_a?(Game_Enemy)
            if @active_battler.restriction == 3
              @target_battlers = [$game_troop.random_target_enemy]
            elsif @active_battler.restriction == 2
              @target_battlers = [$game_party.random_target_actor]
            else
              targets = []
              if @active_battler.current_action.forcing
                targets = [$game_party.actors[@active_battler.current_action.target_index]]
              else
                targets = @active_battler.current_action.targets
              end
              @target_battlers = smooth_target_battlers(targets)
            end
          end
          # sog[AN^[̏ꍇ
          if @active_battler.is_a?(Game_Actor)
            if @active_battler.weapon.nil?
              @animation2_id = ACTION_BASIC_ATTACK_DEFAULT_ANIMATION2_ID
            end
            if @active_battler.restriction == 3
              @target_battlers = [$game_party.random_target_actor]
            elsif @active_battler.restriction == 2
              @target_battlers = [$game_troop.random_target_enemy]
            else
              targets = []
              if @active_battler.current_action.forcing
                targets = [$game_troop.enemies[@active_battler.current_action.target_index]]
              else
                targets = @active_battler.current_action.targets
              end
              @target_battlers = smooth_target_battlers(targets)
            end
          end
          # Xe[gobNAbv
          backup_target_battlers_states
          # ʏǓʂKp
          for target in @target_battlers
            target.attack_effect(@active_battler)
          end
          # ANVOiUj
          action_log_attack
          return
        end
        # h̏ꍇ
        if @active_battler.current_action.basic == 1
          # ANVOihj
          action_log_guard
          return
        end
        # ̏ꍇ
        if @active_battler.is_a?(Game_Enemy) and
        @active_battler.current_action.basic == 2
          # ANVOij
          action_log_escape
          # 
          @active_battler.escape
          return
        end
        # Ȃ̏ꍇ
        if @active_battler.current_action.basic == 3
          # ANVΏۂ̃og[NA
          $game_temp.forcing_battler = nil
          # Xebv 1 Ɉڍs
          @phase4_step = 1
          return
        end
      end

      #--------------------------------------------------------------------------
      #  XLANV ʍ쐬
      #--------------------------------------------------------------------------
      def make_skill_action_result
        # XL擾
        @skill = $data_skills[@active_battler.current_action.skill_id]
        # ANVłȂ
        unless @active_battler.current_action.forcing
          # SP ؂ȂǂŎgpłȂȂꍇ
          unless @active_battler.skill_can_use?(@skill.id)
            # ANVΏۂ̃og[NA
            $game_temp.forcing_battler = nil
            # Xebv 1 Ɉڍs
            @phase4_step = 1
            action_log_skill_not_use(@skill)
            return
          end
        end
        # SP 
        @active_battler.sp -= @skill.sp_cost
        # Xe[^XEBhEtbV
        #refresh_status_window
        # Aj[V ID ݒ
        @animation1_id = @skill.animation1_id
        @animation2_id = @skill.animation2_id
        # RCxg ID ݒ
        @common_event_id = @skill.common_event_id
        # Ώۑog[ݒ
        set_target_battlers(@skill.scope)
        # Xe[gobNAbv
        backup_target_battlers_states
        # XĽʂKp
        for target in @target_battlers
          target.skill_effect(@active_battler, @skill)
        end
        # ANVOiXLj
        action_log_skill
      end

      #--------------------------------------------------------------------------
      #  ACeANV ʍ쐬
      #--------------------------------------------------------------------------
      def make_item_action_result
        # ύX̏ꍇ
        if @active_battler.current_action.basic == 1
          # Xebv 1 Ɉڍs
          @phase4_step = 1
          # ACe擾
          @item = @active_battler.current_action.item
          # ANVOiACej
          action_log_item_equip
          return
        end

        # ACe擾
        use_item = @active_battler.current_action.item
        targets = @active_battler.current_action.targets
        @item = Item_Facade.get_use_item(use_item)
        @item = use_item if @item.nil?
        # ACe؂ȂǂŎgpłȂȂꍇ
        unless Item_Facade.item_can_use?(use_item,@active_battler,targets)
          # Xebv 1 Ɉڍs
          @phase4_step = 1
          # ANVOiACej
          action_log_item
          return
        end
        # Ώۑog[ݒ
        set_target_battlers(@item.scope)
        # Xe[gobNAbv
        backup_target_battlers_states
        # ACěʂKp
        result = Item_Facade.use_item(use_item,@active_battler,@target_battlers)
        if result
          # Aj[V ID ݒ
          @animation1_id = @item.animation1_id
          @animation2_id = @item.animation2_id
          # RCxg ID ݒ
          @common_event_id = @item.common_event_id
        else
          # Xebv 1 Ɉڍs
          @phase4_step = 1
        end
        # ANVOiACej
        action_log_item
      end

      #--------------------------------------------------------------------------
      #  XL܂̓ACȇΏۑog[ݒ
      #     scope : XL܂̓ACěʔ͈
      #--------------------------------------------------------------------------
      def set_target_battlers(scope)
        # sog[Gl~[̏ꍇ
        if @active_battler.is_a?(Game_Enemy)
          # ʔ͈͂ŕ
          case scope
          when 1  # GP
            targets = @active_battler.current_action.targets
            @target_battlers = smooth_target_battlers(targets)
          when 2  # GS
            for actor in $game_party.actors
              if actor.exist?
                @target_battlers.push(actor)
              end
            end
          when 3  # P
            targets = @active_battler.current_action.targets
            @target_battlers = smooth_target_battlers(targets)
          when 4  # S
            for enemy in $game_troop.enemies
              if enemy.exist?
                @target_battlers.push(enemy)
              end
            end
          when 5  # P (HP 0)
            targets = @active_battler.current_action.targets
            battlers = smooth_target_battlers(targets)
            for battler in battlers
              if battler != nil and battler.hp0?
                @target_battlers.push(battler)
              end
            end
          when 6  # S (HP 0)
            for enemy in $game_troop.enemies
              if enemy != nil and enemy.hp0?
                @target_battlers.push(enemy)
              end
            end
          when 7  # gp
            @target_battlers.push(@active_battler)
          end
        end
        # sog[AN^[̏ꍇ
        if @active_battler.is_a?(Game_Actor)
          # ʔ͈͂ŕ
          case scope
          when 1  # GP
            targets = @active_battler.current_action.targets
            @target_battlers = smooth_target_battlers(targets)
          when 2  # GS
            for enemy in $game_troop.enemies
              if enemy.exist?
                @target_battlers.push(enemy)
              end
            end
          when 3  # P
            targets = @active_battler.current_action.targets
            @target_battlers = smooth_target_battlers(targets)
          when 4  # S
            for actor in $game_party.actors
              if actor.exist?
                @target_battlers.push(actor)
              end
            end
          when 5  # P (HP 0)
            targets = @active_battler.current_action.targets
            for battler in targets
              if battler != nil and battler.hp0?
                @target_battlers.push(battler)
              end
            end
          when 6  # S (HP 0)
            for actor in $game_party.actors
              if actor != nil and actor.hp0?
                @target_battlers.push(actor)
              end
            end
          when 7  # gp
            @target_battlers.push(@active_battler)
          end
        end
      end

      #--------------------------------------------------------------------------
      #  t[XV (CtF[Y Xebv 1 : )
      #--------------------------------------------------------------------------
      def update_phase4_step1_initialize
        # Aj[V ID уRCxg ID 
        @animation1_id = 0
        @animation2_id = 0
        @common_event_id = 0
        # 퓬sRCxghcꍇ͐ݒ
        if Module.constants.include?('BATTLE_ACTION_COMMON_EVENT_ID')
          @battle_action_common_event_id = BATTLE_ACTION_COMMON_EVENT_ID
        else
          @battle_action_common_event_id = nil
        end
        # sog[z̐擪Vtg
        @active_battler = @action_battlers.shift
      end

      #--------------------------------------------------------------------------
      #  t[XV (CtF[Y Xebv 1 : ANV)
      #--------------------------------------------------------------------------
      def update_phase4_step1
        # s
        if judge
          # ܂͔sk̏ꍇ : \bhI
          Phase_Battle_End.start
          return
        end
        # ANVĂog[݂Ȃꍇ
        if $game_temp.forcing_battler == nil
          # ogCxgZbgAbv
          setup_battle_event
          # ogCxgs̏ꍇ
          if $game_system.battle_interpreter.running?
            return
          end
        end
        # ANVĂog[݂ꍇ
        if $game_temp.forcing_battler != nil
          # 擪ɒǉ܂͈ړ
          @action_battlers.delete($game_temp.forcing_battler)
          @action_battlers.unshift($game_temp.forcing_battler)
        end
        # sog[݂Ȃꍇ (Ss)
        if @action_battlers.size == 0
          # CItF[Y
          Phase_Main_End.start
          return
        end
        # Setp1 
        update_phase4_step1_initialize()
        # łɐ퓬OĂꍇ
        if @active_battler.index == nil
          return
        end
        # Xe[gobNAbv
        last_states = @active_battler.states.clone
        # Xe[gR
        @active_battler.remove_states_auto
        # Xe[gRO
        delete_states = last_states - @active_battler.states
        if not delete_states.empty?
          action_log_remove_states_auto(delete_states)
        end
        # Xe[^XEBhEtbV
        #refresh_status_window
        # Xebv 2 Ɉڍs
        @phase4_step = 2
      end

      #--------------------------------------------------------------------------
      #  t[XV (CtF[Y Xebv 2 : ANVJn)
      #--------------------------------------------------------------------------
      def update_phase4_step2
        # ANVłȂ
        unless @active_battler.current_action.forcing
          #  [GʏU]  [ʏU] ̏ꍇ
          if @active_battler.restriction == 2 or @active_battler.restriction == 3
            # ANVɍUݒ
            @active_battler.current_action.kind = 0
            @active_battler.current_action.basic = 0
          end
          #  [słȂ] ̏ꍇ
          if @active_battler.restriction == 4
            # ANVΏۂ̃og[NA
            $game_temp.forcing_battler = nil
            # Xebv 1 Ɉڍs
            @phase4_step = 1
            action_log_forcing_not_action_states()
            return
          end
        end
        # Ώۃog[NA
        @target_battlers = []
        # ANV̎ʂŕ
        case @active_battler.current_action.kind
        when 0  # {
          make_basic_action_result
        when 1  # XL
          make_skill_action_result
        when 2  # ACe
          make_item_action_result
        end
        # Xebv 3 Ɉڍs
        if @phase4_step == 2
          @phase4_step = 3
        end
      end

      #--------------------------------------------------------------------------
      #  t[XV (CtF[Y Xebv 3 : sAj[V)
      #--------------------------------------------------------------------------
      def update_phase4_step3
        # sAj[VCX^X
        battler = nil
        case @active_battler
        when Game_Enemy
          battler = @active_battler
        when Game_Actor
          battler = $scene.spriteset.dummy_sprite
        end

        # sAj[V (ID  0 ̏ꍇ͔tbV)
        if @animation1_id == 0
          battler.white_flash = true
        else
          battler.animation_id = @animation1_id
          battler.animation_hit = true
        end
        # Xebv 4 Ɉڍs
        @phase4_step = 4
        # ANVOiXebvRj
        action_log_step3
      end

      #--------------------------------------------------------------------------
      #  t[XV (CtF[Y Xebv 4 : ΏۑAj[V)
      #--------------------------------------------------------------------------
      def update_phase4_step4
        # ΏۑAj[V
        @target_battlers.each do |target|
          # ΏۑAj[VCX^X
          battler = nil
          case target
          when Game_Enemy
            battler = target
          when Game_Actor
            battler = $scene.spriteset.dummy_sprite
          end
          battler.animation_id = @animation2_id
          battler.animation_hit = (target.damage != "Miss")
        end
        # Xebv 5 Ɉڍs
        @phase4_step = 5
      end

      #--------------------------------------------------------------------------
      #  t[XV (CtF[Y Xebv 5 : _[W\)
      #--------------------------------------------------------------------------
      def update_phase4_step5
        if not @target_battlers.empty?
          # ANVOi_[Wj
          action_log_damage
          @target_battlers.shift
          return
        end
        # Xbv_[W
        if @active_battler.hp > 0 and @active_battler.slip_damage? and @slip_damage_log_flag.nil?
          #          backup_target_battlers_states
          @active_battler.slip_damage_effect
          #      @active_battler.damage_pop = true
          action_log_slip_damage()
          @slip_damage_log_flag = true
          return
        end
        @slip_damage_log_flag = nil
        # Xebv 6 Ɉڍs
        @phase4_step = 6
      end

      #--------------------------------------------------------------------------
      #  t[XV (CtF[Y Xebv 6 : tbV)
      #--------------------------------------------------------------------------
      def update_phase4_step6
        # Xe[^XEBhEtbV
        refresh_status_window
        # ANVΏۂ̃og[NA
        $game_temp.forcing_battler = nil
        # RCxg ID L̏ꍇ
        if @common_event_id > 0
          # CxgZbgAbv
          common_event = $data_common_events[@common_event_id]
          $game_system.battle_interpreter.setup(common_event.list, 0)
        end
        # 퓬sRCxg ID L̏ꍇ
        if not @battle_action_common_event_id.nil?
          # CxgZbgAbv
          common_event = $data_common_events[@battle_action_common_event_id]
          $game_system.battle_interpreter.setup(common_event.list, 0)
          @battle_action_common_event_id = nil
        else
          # Xebv 1 Ɉڍs
          @phase4_step = 1
        end
      end

      def smooth_target_battlers(targets,battlers=nil)
        if battlers.nil?
          if targets[0].is_a? Game_Actor
            battlers = $game_party.actors
          end
          if targets[0].is_a? Game_Enemy
            battlers = $game_troop.enemies
          end
        end
        result = []
        for target in targets
          if target != nil and target.exist?
            result.push target
          end
        end
        if not result.empty?
          return result
        end
        for battler in battlers
          if battler != nil and battler.exist?
            result.push battler
            break
          end
        end
        return result
      end

      def get_properties(object,key,default_value)
        value = nil
        if not object.properties[key].nil?
          value = object.properties[key]
        end
        if value.nil?
          value = default_value
        end
        return value
      end

      def action_log_step3
        # ANVʕ\Cxg
        return if @target_battlers.empty?
        @target = @target_battlers[0]
        if target.critical
          action_event = Script_Event.new
          action_event.se_start(@@action_log_critical_se)
          msg = '\scroll_lock'
          case @active_battler
          when Game_Actor
            msg << @@action_log_default_actor_critical
          when Game_Enemy
            msg << @@action_log_default_enemy_critical
          end
          msg << '\n'
          action_event.message(msg)
          action_event_start(action_event)
        end
      end

      # UXe[g擾
      def get_forcing_attack_states(states)
        forcing_states = []
        for state_id in states
          state = $data_states[state_id]
          if state.restriction == 2 or state.restriction == 3
            forcing_states.push state
          end
        end
        return forcing_states
      end

      # ss\Xe[g擾
      def get_forcing_not_action_states(states)
        forcing_states = []
        for state_id in states
          state = $data_states[state_id]
          if state.restriction == 4
            forcing_states.push state
          end
        end
        return forcing_states
      end

      # كXe[g擾
      def get_silence_states(states)
        forcing_states = []
        for state_id in states
          state = $data_states[state_id]
          if state.restriction == 1
            forcing_states.push state
          end
        end
        return forcing_states
      end

      # UXe[gANVO
      def action_log_forcing_attack_states(action_event)
        # ANVʕ\Cxg
        states = []
        # ^[Qbg̏ꍇ
        if @active_battler == @target_battlers[0]
          # obNAbv擾
          states = get_backup_target_battlers_states(@active_battler)
        else
          # ݒ肳ĂXe[g
          states = @active_battler.states
        end
        if states.empty?
          return
        end
        # UXe[g擾
        forcing_states = get_forcing_attack_states(states)
        if forcing_states.empty?
          return
        end
        action_event.message('\clear')
        for state in forcing_states
          action_log_default_forcing_attack_states = "\\active_battler.name ́@#{state.name}\\n"
          msg = get_properties(state,'action_log_forcing_attack_states',action_log_default_forcing_attack_states)
          action_event.message(msg)
        end
        action_event.wait($scene.message_window.auto_message_interval)
      end

      # ss\ANVO
      def action_log_forcing_not_action_states
        # łꍇ́A\Ȃ
        if @active_battler.dead?
          return
        end

        # ANVʕ\Cxg
        @target = @active_battler
        action_event = Script_Event.new
        forcing_states = get_forcing_not_action_states(@active_battler.states)
        if forcing_states.empty?
          return
        end
        action_event.message('\clear')
        for state in forcing_states
          default_log = "\\active_battler.namé@#{state.name}ĂI\\n"
          msg = get_properties(state,'action_log_forcing_not_action_states',default_log)
          action_event.message(msg)
        end
        action_event.wait($scene.message_window.auto_message_interval)
        action_event_start(action_event)
      end

      # UANVO
      def action_log_attack
        # ANVʕ\Cxg
        action_event = Script_Event.new
        action_log_forcing_attack_states(action_event)
        msg = '\clear'
        msg << @@action_log_default_attack
        msg << '\n'
        action_event.message(msg)
        action_event_start(action_event)
      end

      # hANVO
      def action_log_guard
        # ANVʕ\Cxg
        action_event = Script_Event.new
        msg = '\clear'
        msg << @@action_log_default_guard
        msg << '\n'
        action_event.message(msg)
        action_event_start(action_event)
      end

      # ANVO
      def action_log_escape
        # ANVʕ\Cxg
        action_event = Script_Event.new
        msg = '\clear'
        msg << @@action_log_default_escape
        msg << '\n'
        action_event.message(msg)
        action_event_start(action_event)
      end

      # XLANVO
      def action_log_skill
        # ANVʕ\Cxg
        action_event = Script_Event.new
        action_log_skills(action_event)
        action_event_start(action_event)
      end

      # XLANVO
      def action_log_skills(action_event)
        msg = '\clear'
        if skill.atk_f == 0 # U͂eȌꍇ͖@XL
          msg << get_properties(skill,'action_log_skill',@@action_log_default_magic_skill)
        else
          msg << get_properties(skill,'action_log_skill',@@action_log_default_attack_skill)
        end
        msg << '\n'
        action_event.message(msg)
        action_event.method_call(method(:refresh_status_window),@active_battler,3)
      end

      # XLgps\ANVO
      def action_log_skill_not_use(skill)
        # ANVʕ\Cxg
        action_event = Script_Event.new
        action_log_skills(action_event)

        # SP Ȃꍇ
        if $data_skills[skill.id].sp_cost > @active_battler.sp
          default_log = "#{$data_system.words.sp}@ȂI\\n"
          msg = '\scroll_lock'
          msg << get_properties(skill,'action_log_skill_not_use_sp',default_log)
          action_event.message(msg)
        end

        # ُԂ̏ꍇAXLȊO͎gps
        if $data_skills[skill.id].atk_f == 0 and @active_battler.restriction == 1
          states = []
          # ^[Qbg̏ꍇ
          if @active_battler == @target_battlers[0]
            # obNAbv擾
            states = get_backup_target_battlers_states(@active_battler)
          else
            # ݒ肳ĂXe[g
            states = @active_battler.states
          end
          if not states.empty?
            silence_states = get_silence_states(states)
            for state in silence_states
              default_log = "\\active_battler.namé@#{state.name}Ă\\n"
              msg = '\scroll_lock'
              msg << get_properties(state,'action_log_skill_not_use_state',default_log)
              action_event.message(msg)
            end
          end
        end
        action_event.wait($scene.message_window.auto_message_interval)
        action_event_start(action_event)
      end

      # ACeANVO
      def action_log_item
        # ANVʕ\Cxg
        action_event = Script_Event.new
        action_log_items(action_event)
        action_event_start(action_event)
      end

      # ACeANVO
      def action_log_items(action_event)
        msg = '\clear\scroll_lock'
        msg << get_properties(item,'action_log_item_use_msg',@@action_log_default_item_use_msg)
        msg << '\n'
        action_event.message(msg)
        action_event.wait($scene.message_window.auto_message_interval)

        if Item_Facade.last_result
          hit_msg = get_properties(item,'action_log_item_hit_msg',@@action_log_default_item_hit_msg)
          if not hit_msg.nil?
            msg = '\scroll_lock'
            msg << hit_msg
            msg << '\n'
            action_event.message(msg)
          end
        else
          action_event.wait($scene.message_window.auto_message_interval)
          msg = '\scroll_lock'
          msg << get_properties(item,'action_log_item_miss_msg',@@action_log_default_item_miss_msg)
          msg << '\n'
          action_event.message(msg)
          action_event.wait($scene.message_window.auto_message_interval)
          for target in @target_battlers
            target.damage = nil
          end
          @target_battlers.clear
        end
      end

      # ANVO
      def action_log_item_equip
        # ANVʕ\Cxg
        if not @active_battler.is_a?(Game_Actor)
          return
        end
        action_event = Script_Event.new
        msg = '\clear\scroll_lock'
        if Item_Facade.actor_equip?(@item,@active_battler)
          msg << '\active_battler.namé@\item.name@͂I'
          @active_battler.remove_equip_item(@item)
        else
          msg << '\active_battler.namé@\item.name@тI'
          @active_battler.equip_item(@item)
        end
        msg << '\n'
        action_event.se_start($data_system.equip_se)
        action_event.message(msg)
        action_event.wait($scene.message_window.auto_message_interval)
        action_event_start(action_event)
      end

      # _[WO
      def action_log_damage
        action_event = Script_Event.new

        @target = @target_battlers[0]

        action_log_damage_hp(action_event)
        action_log_damage_sp(action_event)
        action_log_states(action_event)

        @target = @target_battlers[0].dup
        # XXX ̏́AۗBłIł悤ȃJX^}CY|Cg
        # @target_battlers[0].damage_pop = true
        @target_battlers[0].damage = nil
        @target_battlers[0].damage_sp = nil
        #        $scene.wait_count = $scene.message_window.auto_message_interval
        #        $scene.wait_count = 8

        action_event_start(action_event)
      end

      # go_[WO
      def action_log_damage_hp(action_event)
        if target.damage.nil?
          return
        end
        if target.damage.is_a? Numeric
          if target.damage >= 0
            if target.is_a? Game_Actor
              action_event.se_start(@@action_log_shake_window_se)
              action_event.script("$scene.shaker.start_shake(2,40,10)")
              action_event.script("$scene.shaker.update_interpreter")
            end
            msg = '\delete_line[1,3]\current_line[1]'
            if target.is_a? Game_Actor
              msg << '\scroll_lock'
              msg << "\\target.namé@\\target.damagẽ_[WI\\n"
            else
              msg << '\scroll_lock'
              msg << "\\target.nameɁ@\\target.damagé@_[WII\\n"
            end
            action_event.message(msg)
            action_event.se_start(@@action_log_attack_hit_se)
          else
            msg = '\delete_line[1,3]\current_line[1]\scroll_lock'
            msg << "\\target.namé@\\target.damage@ӂII\\n"
            action_event.message(msg)
          end
        elsif target.damage == 'Miss'
          action_event.se_start(@@action_log_attack_miss_se)
          msg = '\delete_line[1,3]\current_line[1]\scroll_lock'
          msg << "\\target.nameɁ@\\target.damageII\\n"
          action_event.message(msg)
        end
        action_event.wait($scene.message_window.auto_message_interval)
        action_event.method_call(method(:refresh_status_window),target)
      end

      # ro_[WO
      def action_log_damage_sp(action_event)
        if target.damage_sp.nil?
          return
        end
        if target.damage_sp.is_a? Numeric
          if target.damage_sp == 0
            return
          end
          if target.damage_sp > 0
            action_event.se_start(@@action_log_attack_hit_se)
            if target.is_a? Game_Actor
              action_event.se_start(@@action_log_shake_window_se)
              action_event.script("$scene.shaker.start_shake(2,40,10)")
              action_event.script("$scene.shaker.update_interpreter")
            end
            msg = '\delete_line[1,3]\current_line[1]\scroll_lock'
            if target.is_a? Game_Actor
              msg << @@action_log_default_damage_sp_actor
            else
              msg << @@action_log_default_damage_sp_enemy
            end
            msg << '\n'
            action_event.message(msg)
          else
            msg = '\delete_line[1,3]\current_line[1]\scroll_lock'
            if target.is_a? Game_Actor
              msg << @@action_log_default_recover_sp_actor
            else
              msg << @@action_log_default_recover_sp_enemy
            end
            msg << '\n'
            action_event.message(msg)
          end
        end
        action_event.wait($scene.message_window.auto_message_interval)
        action_event.method_call(method(:refresh_status_window),target)
      end

      # Xe[^XO
      def action_log_states(action_event)
        new_states = target_battlers_new_states(target)
        for state_id in new_states
          new_state = $data_states[state_id]
          msg = ''
          if target.damage == ''
            msg << '\delete_line[1,3]\current_line[1]'
          end
          msg << '\scroll_lock'
          state_msg = nil
          case target
          when Game_Actor
            if not new_state.properties['action_log_new_actor'].nil?
              state_msg = new_state.properties['action_log_new_actor']
            end
          when Game_Enemy
            if not new_state.properties['action_log_new_enemy'].nil?
              state_msg = new_state.properties['action_log_new_enemy']
            end
          end
          if state_msg.nil?
            state_msg = "\\target.namé@#{new_state.name}Ɂ@Ȃ"
          end
          msg << state_msg << '\n'
          action_event.message(msg)
          action_event.wait($scene.message_window.auto_message_interval)
          action_event.method_call(method(:refresh_status_window),target)
        end
        # ł񕜃Xe[g͕\Ȃ
        if target.dead?
          return
        end
        delete_states = target_battlers_delete_states(target)
        action_log_delete_states(action_event,delete_states)
      end

      # 폜Xe[^XO
      def action_log_delete_states(action_event,delete_states)
        for state_id in delete_states
          delete_state = $data_states[state_id]
          msg = ''
          if action_event.event_commands.empty?
            # ŏ̃Cxg̏ꍇ
            msg = '\clear\scroll_lock'
          else
            # Cxgꍇ
            if target.damage == ''
              msg = '\delete_line[1,3]\current_line[1]'
            end
          end
          msg << '\scroll_lock'
          state_msg = nil
          case target
          when Game_Actor
            if not delete_state.properties['action_log_delete_actor'].nil?
              state_msg = delete_state.properties['action_log_delete_actor']
            end
          when Game_Enemy
            if not delete_state.properties['action_log_delete_enemy'].nil?
              state_msg = delete_state.properties['action_log_delete_enemy']
            end
          end
          if state_msg.nil?
            state_msg = "\\target.namé@#{delete_state.name}@ӂ"
          end
          msg << state_msg << '\n'
          action_event.message(msg)
          action_event.method_call(method(:refresh_status_window),target)
          action_event.wait($scene.message_window.auto_message_interval)
        end
      end

      # 폜Xe[^XO
      def action_log_remove_states_auto(delete_states)
        action_event = Script_Event.new
        @target = @active_battler
        action_log_delete_states(action_event,delete_states)
        action_event_start(action_event)
      end

      # TODO Xbv_[WO
      def action_log_slip_damage()
        @target = @active_battler
        if not target.damage.nil?
          action_event = Script_Event.new
          if target.damage.is_a? Numeric
            if target.damage >= 0
              action_event.se_start(@@action_log_attack_hit_se)
              if target.is_a? Game_Actor
                action_event.se_start(@@action_log_shake_window_se)
                action_event.script("$scene.shaker.start_shake(2,20,5)")
                action_event.script("$scene.shaker.update_interpreter")
              end
              msg = ''
              if target.is_a? Game_Actor
                msg << '\scroll_lock'
                msg << "\\active_battler.namé@\\active_battler.damagẽ_[WI\\n"
              else
                msg << '\scroll_lock'
                msg << "\\active_battler.nameɁ@\\active_battler.damagé@_[WII\\n"
              end
              action_event.message(msg)
            else
              msg = '\delete_line[1,3]\current_line[1]\scroll_lock'
              msg << "\\active_battler.namé@\\active_battler.damage@ӂII\\n"
              action_event.message(msg)
            end
            action_event.wait($scene.message_window.auto_message_interval)
            action_event.method_call(method(:refresh_status_window),target)
            if target.dead?
              action_event.message('\clear')
              action_log_states(action_event)
              action_event.wait($scene.message_window.auto_message_interval)
            end
          end
        end
        action_event_start(action_event)
      end

    end
  end
end
